/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.block;

import gloridifice.watersource.common.capability.WaterLevelCapability;
import gloridifice.watersource.registry.ConfigRegistry;
import gloridifice.watersource.registry.EffectRegistry;
import gloridifice.watersource.registry.FluidRegistry;
import gloridifice.watersource.registry.TileEntityTypesRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class WaterDispenserBlock
extends Block {
    public static final BooleanProperty IS_UP = BooleanProperty.func_177716_a((String)"up");

    public WaterDispenserBlock(String name, AbstractBlock.Properties properties) {
        super(properties);
        this.setRegistryName(name);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)IS_UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.EAST));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{IS_UP, BlockStateProperties.field_208157_J});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return (Boolean)state.func_177229_b((Property)IS_UP) != false ? TileEntityTypesRegistry.WATER_DISPENSER_UP.func_200968_a() : TileEntityTypesRegistry.WATER_DISPENSER_DOWN.func_200968_a();
    }

    public void func_180633_a(World world, BlockPos blockPos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        world.func_175656_a(blockPos.func_177984_a(), (BlockState)this.getStateForPlacement(livingEntity).func_206870_a((Property)IS_UP, (Comparable)Boolean.valueOf(true)));
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, world, pos, explosion);
        this.onBlockRemoved(world, pos, state);
    }

    public void onBlockRemoved(World world, BlockPos blockPos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)IS_UP)).booleanValue()) {
            world.func_175656_a(blockPos.func_177977_b(), Blocks.field_150350_a.func_176223_P());
        } else {
            world.func_175656_a(blockPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
        }
    }

    public void func_176208_a(World world, BlockPos blockPos, BlockState state, PlayerEntity playerEntity) {
        this.onBlockRemoved(world, blockPos, state);
        super.func_176208_a(world, blockPos, state, playerEntity);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195991_k().func_175623_d(context.func_195995_a().func_177984_a()) && context.func_195995_a().func_177984_a().func_177956_o() < 255) {
            return this.getStateForPlacement((LivingEntity)context.func_195999_j());
        }
        return null;
    }

    public BlockState getStateForPlacement(LivingEntity living) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)living.func_174811_aO().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        TileEntity tile = world.func_175625_s(blockPos);
        WaterLevelCapability.Data data = (WaterLevelCapability.Data)player.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).orElse(null);
        IFluidHandler fluidHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            return FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)fluidHandler) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        if (player.func_225608_bj_()) {
            if (fluidHandler.getFluidInTank(0).getAmount() > 0) {
                world.func_184133_a(player, blockPos, SoundEvents.field_187624_K, SoundCategory.PLAYERS, 1.0f, 1.0f);
                fluidHandler.drain(fluidHandler.getTankCapacity(0), IFluidHandler.FluidAction.EXECUTE);
                return ActionResultType.SUCCESS;
            }
        } else if (data.getWaterLevel() < 20 && fluidHandler.getFluidInTank(0).getAmount() >= 250) {
            Fluid fluid = fluidHandler.getFluidInTank(0).getFluid();
            if (((FlowingFluid)FluidRegistry.PURIFIED_WATER.get()).getFluid().equals(fluid)) {
                data.restoreWater(player, 5, 6);
            } else if (((FlowingFluid)FluidRegistry.SOUL_WATER.get()).getFluid().equals(fluid)) {
                data.restoreWater(player, 4, 3);
                player.func_195064_c(new EffectInstance(EffectRegistry.ACCOMPANYING_SOUL, 8000, 0));
            } else if (fluid.equals(Fluids.field_204546_a)) {
                data.restoreWater(player, 5, 0);
                if ((Integer)ConfigRegistry.THIRST_DEBUFF_DURATION.get() > -1) {
                    player.func_195064_c(new EffectInstance(EffectRegistry.THIRST, ((Integer)ConfigRegistry.THIRST_DEBUFF_DURATION.get()).intValue(), 0));
                }
            } else {
                return ActionResultType.PASS;
            }
            fluidHandler.drain(250, IFluidHandler.FluidAction.EXECUTE);
            world.func_184133_a(player, blockPos, SoundEvents.field_187664_bz, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

